/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;

public class BBS
extends BuildOrder {
    boolean scoutRequested = false;
    boolean cannonBuildDetected = false;
    boolean zealotRushDetected = false;
    private MassTank massTank = new MassTank();
    private TvP tvp = new TvP();

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        bot.army.rallyPoint = new Position(game.mapWidth() * 16, game.mapHeight() * 16);
        bot.builders.clearEmptyMineralPatches = false;
        if (bot.count(UnitType.Terran_Marine) > 0 && !this.scoutRequested) {
            this.scoutRequested = true;
            this.tvp.scoutRequested = true;
            int i = 0;
            while (i < (bot.suspectedEnemy.size() >= 3 ? 2 : 1)) {
                bot.scout.requestWorkerScout(bot);
                ++i;
            }
        }
        if (!this.zealotRushDetected) {
            if (bot.enemyDefensiveStructures.size() > 0) {
                this.cannonBuildDetected = true;
            }
            if (this.cannonBuildDetected) {
                if (bot.count(UnitType.Terran_Siege_Tank_Siege_Mode) + bot.count(UnitType.Terran_Siege_Tank_Tank_Mode) < 5) {
                    this.massTank.onFrame(game, self, bot);
                } else {
                    this.tvp.onFrame(game, self, bot);
                }
                return;
            }
        }
        if (!this.cannonBuildDetected) {
            int gatewayCount = 0;
            for (EnemyPosition enemy : bot.enemyBuildingMemory) {
                if (enemy.type != UnitType.Protoss_Gateway) continue;
                ++gatewayCount;
            }
            if (gatewayCount >= 2) {
                if (bot.scout.opponentStrategy == ScoutGroup.zealotPush) {
                    bot.army.requiredSize = 40;
                }
                bot.army.maximumSize = 60;
                this.zealotRushDetected = true;
            }
            if (!this.zealotRushDetected) {
                int zealots = 0;
                for (Unit enemy : game.enemy().getUnits()) {
                    if (enemy.getType() != UnitType.Protoss_Zealot) continue;
                    ++zealots;
                }
                if (zealots >= 5) {
                    bot.army.requiredSize = 40;
                    bot.army.maximumSize = 60;
                    this.zealotRushDetected = true;
                }
            }
            if (this.zealotRushDetected) {
                if (bot.count(UnitType.Terran_Bunker) == 0 && bot.count(UnitType.Terran_Barracks) > 0) {
                    if (bot.getAvailableMinerals() >= 100 && bot.defensiveStructures.size() >= 0) {
                        bot.buildDefensive(UnitType.Terran_Bunker, bot.defensiveStructures.get(0));
                    }
                    return;
                }
                this.tvp.onFrame(game, self, bot);
                return;
            }
        }
        bot.army.requiredSize = 5;
        bot.army.maximumSize = 5;
        if (bot.suspectedEnemy.size() == 1 && bot.getAvailableMinerals() >= 100 && bot.count(UnitType.Terran_Marine) >= 8 && bot.count(UnitType.Terran_Bunker) < 1) {
            Position enemyPos = bot.suspectedEnemy.get(0).getPosition();
            Position expo = null;
            int distance = Integer.MAX_VALUE;
            for (BaseLocation loc : bot.expands) {
                int newDist = (int)enemyPos.getDistance(loc.getPosition());
                if (newDist >= distance) continue;
                distance = newDist;
                expo = loc.getPosition();
            }
            if (expo != null) {
                bot.build(UnitType.Terran_Bunker, expo);
            }
        }
        if (bot.getAvailableMinerals() >= 150 && bot.count(UnitType.Terran_Barracks) < 2) {
            int i = bot.count(UnitType.Terran_Barracks);
            while (i < 2) {
                bot.build(UnitType.Terran_Barracks, new Position(game.mapWidth() * 16, game.mapHeight() * 16));
                ++i;
            }
        }
        if (bot.getAvailableMinerals() >= 100 && bot.count(UnitType.Terran_Barracks) == 2 && bot.count(UnitType.Terran_Supply_Depot) == 0) {
            bot.build(UnitType.Terran_Supply_Depot);
        }
        if (bot.getAvailableMinerals() >= 100 && bot.count(UnitType.Terran_Barracks) == 2 && bot.count(UnitType.Terran_Supply_Depot) > 0 && self.supplyTotal() + bot.supplyConstructing - self.supplyUsed() <= 4 && self.supplyTotal() + bot.supplyConstructing < 400) {
            bot.build(UnitType.Terran_Supply_Depot);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (this.cannonBuildDetected) {
            if (agent.unit.getType() == UnitType.Terran_Barracks && bot.count(UnitType.Terran_Machine_Shop) == 0 && bot.getAvailableMinerals() <= 250) {
                return true;
            }
            return this.massTank.overrideStructureOrder(game, self, bot, agent);
        }
        if (this.zealotRushDetected) {
            if (bot.count(UnitType.Terran_Bunker) == 0) {
                return true;
            }
            return this.tvp.overrideStructureOrder(game, self, bot, agent);
        }
        if (agent.unit.getType() == UnitType.Terran_Command_Center) {
            if (!(bot.count(UnitType.Terran_Marine) != 0 && bot.getAvailableMinerals() < 250 || agent.unit.isTraining() || bot.getAvailableMinerals() < 50)) {
                if (bot.count(UnitType.Terran_SCV) < 8) {
                    agent.unit.train(UnitType.Terran_SCV);
                } else if (bot.count(UnitType.Terran_Barracks) >= 2 && bot.count(UnitType.Terran_SCV) < 9) {
                    agent.unit.train(UnitType.Terran_SCV);
                } else if (bot.count(UnitType.Terran_Supply_Depot) >= 1) {
                    agent.unit.train(UnitType.Terran_SCV);
                }
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 50) {
                agent.unit.train(UnitType.Terran_Marine);
            }
            return true;
        }
        return false;
    }
}

