/*
 * Decompiled with CFR 0.152.
 */
import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;

public class Attack
extends Command {
    private Position target;
    private static int waitFrame;
    private static int waitingAtCannon;
    private static int waitingAtCannonPrev;

    public Attack(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Red);
        if (waitFrame != game.getFrameCount()) {
            waitingAtCannonPrev = waitingAtCannon;
            DebugMessages.addMessage("Waiting at cannon: " + waitingAtCannon);
            waitingAtCannon = 0;
            waitFrame = game.getFrameCount();
        }
        boolean inrange = false;
        boolean proceed = bot.scout.opponentStrategy != ScoutGroup.cannons && waitingAtCannonPrev >= 10 || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode;
        int dist = UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() + 64;
        int smallDist = UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() - 32;
        if (bot.scout.opponentStrategy != ScoutGroup.cannons) {
            smallDist += 32;
        }
        for (EnemyPosition enemy : bot.enemyDefensiveStructures) {
            if (this.agent.unit.getType() == UnitType.Terran_Battlecruiser) break;
            if (enemy.type != UnitType.Protoss_Photon_Cannon || Math.abs(this.agent.unit.getX() - enemy.pos.getX()) > dist || Math.abs(this.agent.unit.getY() - enemy.pos.getY()) > dist || this.agent.distanceSquared(enemy.pos) > dist * dist) continue;
            inrange = this.agent.distanceSquared(enemy.pos) <= smallDist * smallDist;
            ++waitingAtCannon;
            break;
        }
        if (inrange && !this.agent.unit.isHoldingPosition() && !proceed) {
            this.agent.unit.holdPosition();
        } else if (proceed || !inrange) {
            this.attack();
        } else {
            Tyr.bot.drawCircle(this.agent.unit.getPosition(), Color.Blue, 6);
        }
    }

    private void attack() {
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            for (Unit unit : Tyr.game.enemy().getUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || this.agent.distanceSquared(unit) > radius * radius) continue;
                Tyr.game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.agent.unit.siege();
                this.agent.drawCircle(Color.Red, 6);
                return;
            }
            if (this.agent.unit.isIdle() || Tyr.bot.defenseTime == 0) {
                this.agent.drawCircle(Color.White, 6);
                this.agent.unit.attack(this.target);
                return;
            }
            this.agent.drawCircle(Color.Blue, 6);
            return;
        }
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            for (Unit unit : Tyr.game.enemy().getUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || this.agent.distanceSquared(unit) > radius * radius) continue;
                Tyr.game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.agent.drawCircle(Color.Red, 6);
                return;
            }
            this.agent.drawCircle(Color.White, 6);
            this.agent.unit.unsiege();
            return;
        }
        if (this.agent.distanceSquared(this.target) <= 16384) {
            return;
        }
        Order order = this.agent.unit.getOrder();
        Position orderTarget = this.agent.unit.getOrderTargetPosition();
        if (this.agent.unit.getGroundWeaponCooldown() > 1 && this.agent.unit.getAirWeaponCooldown() > 1) {
            this.agent.unit.move(Tyr.tileToPostion(Tyr.game.self().getStartLocation()));
        } else if (this.agent.unit.isHoldingPosition() || this.agent.unit.isIdle() || this.agent.unit.getGroundWeaponCooldown() == 1 || this.agent.unit.getAirWeaponCooldown() == 1) {
            Tyr.bot.drawCircle(this.agent.unit.getPosition(), Color.Green, 6);
            this.agent.unit.attack(this.target);
        } else {
            double dist = this.target.getDistance(orderTarget);
            if (order == Order.AttackMove && orderTarget != null && this.agent.unit.getTarget() == null && (Math.abs(this.target.getX() - orderTarget.getX()) >= 10 || Math.abs(this.target.getY() - orderTarget.getY()) >= 10 || dist >= 10.0)) {
                Tyr.bot.drawCircle(this.agent.unit.getPosition(), Color.White, 6);
                this.agent.unit.attack(this.target);
            }
        }
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(Attack.class)) {
            return true;
        }
        return ((Attack)command).target.getX() != this.target.getX() || ((Attack)command).target.getY() != this.target.getY();
    }
}

