#pragma once
#include "InformationManager.h"
#include "Utils/DebugMemory.h"

#define WORKERS_PER_MINERAL 2

typedef std::map<BWAPI::Unit, int> ResourceToWorkerMap;
typedef std::map<BWAPI::Unit, BWAPI::Unit> WorkerToTargetMap;
typedef std::map<BWAPI::Unit, std::pair<BWAPI::TilePosition, BWAPI::UnitType> > WorkerToBuildOrderMap;
typedef std::map<BWAPI::Unit, BWAPI::Unit> WorkerToTargetMap;
typedef std::map<BWAPI::Unit, BWTA::BaseLocation*> WorkerToBaseMap;

class WorkerManager
{
public:
	enum State
	{
		Gathering_Mineral,
		Gathering_Gas,
		Building,
		Defending,
		Attacking,
	};
	WorkerManager();
	void addUnit(BWAPI::Unit unit);
	void onUnitDestroy(BWAPI::Unit unit);
	void onMineralDestroy(BWAPI::Unit mineralField);
	void onFrame();
	bool needWorkers();
	BWAPI::Unit getWorkerForTask(BWAPI::Position toPosition);
	int getBuildingWorkers();
	void workerBuildingRefinery();
	bool isUnderConstruction(BWAPI::UnitType type);
	void buildRequest(BWAPI::TilePosition locationToBuild, BWAPI::UnitType buildType);
	bool workersDefending();
	bool workersDefending(BWAPI::Unit target);
	unsigned int getWorkersMining();
	bool defenseBase(BWAPI::Unit unit);
	void rebalanceGathering(); // TODO
	void reassignRemovedMinerals();

	BWAPI::Unitset _workerUnits;
	WorkerToTargetMap _workersTarget;
	ResourceToWorkerMap _mineralsExploitation;
	ResourceToWorkerMap _gasExploitation;
	std::map<BWAPI::Unit, WorkerManager::State> _workerState;
	WorkerToBuildOrderMap _workerBuildOrder;

private:
	log4cxx::LoggerPtr _logger;

	BWAPI::Unit getBestMineral();
	void tryMiningTrick(BWAPI::Unit worker);

	BWAPI::Unitset _workerBuildingRefinery;
	UnitToTimeMap _workerStartBuilding;
	UnitToTimeMap _workerStartAttacking;
};