#ifndef _TIMER_H_
#define _TIMER_H_

#include <windows.h>

class Timer
{
  LARGE_INTEGER lFreq, lStart;
  LONGLONG elapsedTime;

public:
  Timer()
  {
    QueryPerformanceFrequency(&lFreq);
    elapsedTime = 0;
  }

  inline void start()
  {
    QueryPerformanceCounter(&lStart);
  }
  
  inline void stop()
  {
    LARGE_INTEGER lEnd;
    QueryPerformanceCounter(&lEnd);
    elapsedTime += lEnd.QuadPart - lStart.QuadPart;
  }

  inline double getElapsedTime()
  {
    // Return duration in seconds...
    return (double(elapsedTime) / lFreq.QuadPart);
  }

  inline double stopAndGetTime()
  {
      stop();
      return getElapsedTime();
  }
};

#endif // _TIMER_H_