#pragma once
#include "CombatSimulator.h"

bool sortByScore(unitGroup_t* a, unitGroup_t* b) {
	BWAPI::UnitType aType(a->unitTypeId);
	BWAPI::UnitType bType(b->unitTypeId);
	return aType.destroyScore() > bType.destroyScore();
}

struct sortByTypeClass {
	std::vector<float>* typePriority;
	bool operator() (unitGroup_t* a, unitGroup_t* b) {
		return typePriority->at(a->unitTypeId) > typePriority->at(b->unitTypeId);
	}
} sortByType;