#include "HTMLoutput.h"

std::ofstream htmlFile;
EvaluationFunction* evaluationfunction;
bool globalMaxplayer;

void HTMLoutput::createFile(EvaluationFunction* ef, bool maxplayer)
{
	evaluationfunction = ef;
	globalMaxplayer = maxplayer;
	htmlFile.open("bwapi-data\\logs\\test.html");
	htmlFile << "<!DOCTYPE html>" << std::endl;
	htmlFile << "<html>" << std::endl;
	htmlFile << "<head>" << std::endl;
	htmlFile << "  <meta charset=\"utf-8\">" << std::endl;
	htmlFile << "  <title>MCTSCD trace log</title>" << std::endl;
	htmlFile << "  <link rel=\"stylesheet\" type=\"text/css\" href=\"jquery.dataTables.css\">" << std::endl;
	htmlFile << "  <script type=\"text/javascript\" language=\"javascript\" src=\"jquery.js\"></script>" << std::endl;
	htmlFile << "  <script type=\"text/javascript\" language=\"javascript\" src=\"jquery.dataTables.min.js\"></script>" << std::endl;
	htmlFile << "  <script type=\"text/javascript\" language=\"javascript\" class=\"init\">" << std::endl;
	htmlFile << "    $(document).ready(function() {" << std::endl;
	htmlFile << "      $('table.display').dataTable({" << std::endl;
	htmlFile << "        \"paging\": false," << std::endl;
	htmlFile << "        \"searching\": false," << std::endl;
	htmlFile << "        \"info\": false" << std::endl;
	htmlFile << "      });" << std::endl;
	htmlFile << "    });" << std::endl;
	htmlFile << "  </script>" << std::endl;
	htmlFile << "</head>" << std::endl;
	htmlFile << "<body>" << std::endl;
}

void HTMLoutput::printMCTSCDnode(MCTSCD::gameNode_t* node, bool hiddeNode)
{
// 	_ef->evaluate(maxplayer, minplayer, gs2, 0)
	if (hiddeNode) {
		htmlFile << "<div id=\"" << node << "\" style=\"display:none;\">" << std::endl;
	} else {
		htmlFile << "<div id=\"" << node << "\">" << std::endl;
	}
	// print node information
	htmlFile << "<table class=\"list\">" << std::endl;
	htmlFile << "  <tr>" << std::endl;
	htmlFile << "    <th>Visits</th>" << std::endl;
	htmlFile << "    <th>Evaluation</th>" << std::endl;
	htmlFile << "    <th>Reward (Accumulative eval/visits)</th>" << std::endl;
	htmlFile << "    <th>Depth</th>" << std::endl;
	htmlFile << "    <th>Player</td>" << std::endl;
	htmlFile << "    <th>Parent</th>" << std::endl;
	htmlFile << "  </tr>" << std::endl;
	htmlFile << "  <tr>" << std::endl;
	htmlFile << "    <td>" << node->totalVisits << "</td>" << std::endl;
	htmlFile << "    <td>" << evaluationfunction->evaluate(node->gs, globalMaxplayer) << "</td>" << std::endl;
	htmlFile << "    <td>" << node->totalEvaluation / node->totalVisits << "</td>" << std::endl;
	htmlFile << "    <td>" << node->depth << "</td>" << std::endl;
	htmlFile << "    <td>" << node->player << "</td>" << std::endl;
	if (node->parent)
		htmlFile << "    <td><a href=\"javascript:void(0);\" onClick=\"$('#" << node->parent << "').show(); $('#" << node << "').hide()\">" << node->parent << "</a></td>" << std::endl;
	else
		htmlFile << "    <td>ROOT</td>" << std::endl;
	htmlFile << "  </tr>" << std::endl;
	htmlFile << "</table>" << std::endl;

	htmlFile << "<table>" << std::endl;
	htmlFile << "  <tr>" << std::endl;
	htmlFile << "    <td valign=\"top\"><img src=\"map.png\"></td>" << std::endl;
	htmlFile << "    <td valign=\"top\"><pre>" << std::endl;
	
	htmlFile << node->gs.toString() << std::endl;
	if (&node->gs != node->moveGenerator._gs) DEBUG("Game states are different!!");
	htmlFile << node->moveGenerator.toString() << std::endl;

	htmlFile << "    </pre></td>" << std::endl;
	htmlFile << "  </tr>" << std::endl;
	htmlFile << "</table>" << std::endl;

	// print children list
	if (!node->children.empty()) {
		htmlFile << "<table class=\"display\" cellspacing=\"0\">" << std::endl;
		htmlFile << "  <thead>" << std::endl;
		htmlFile << "    <tr>" << std::endl;
		htmlFile << "      <th>Child</th>" << std::endl;
		htmlFile << "      <th>Visits</th>" << std::endl;
		htmlFile << "      <th>Evaluation</th>" << std::endl;
		htmlFile << "      <th>Reward</th>" << std::endl;
		htmlFile << "      <th>Player</th>" << std::endl;
		htmlFile << "      <th>Action</th>" << std::endl;
		htmlFile << "    </tr>" << std::endl;
		htmlFile << "  </thead>" << std::endl;
		htmlFile << "  <tbody>" << std::endl;

		for (unsigned int i = 0; i < node->children.size(); i++) {
			MCTSCD::gameNode_t* child = node->children[i];
			htmlFile << "    <tr>" << std::endl;
			htmlFile << "      <td><a href=\"javascript:void(0);\" onClick=\"$('#" << child << "').show(); $('#" << node << "').hide()\">" << child << "</a></td>" << std::endl;
			htmlFile << "      <td>" << child->totalVisits << "</td>" << std::endl;
			htmlFile << "      <td>" << evaluationfunction->evaluate(child->gs, globalMaxplayer) << "</td>" << std::endl;
			htmlFile << "      <td>" << child->totalEvaluation / child->totalVisits << "</td>" << std::endl;
			htmlFile << "      <td>" << child->player << "</td>" << std::endl;
			htmlFile << "      <td>" << node->moveGenerator.toString(node->actions[i]) << "</td>" << std::endl;
			htmlFile << "    </tr>" << std::endl;
		}

		htmlFile << "  </tbody>" << std::endl;
		htmlFile << "</table>" << std::endl;
	}

	// print simulations
	if (!node->simulations.empty()) {
		htmlFile << "<h2>" << node->simulations.size() << " Simulations</h2>" << std::endl;
		htmlFile << "<table class=\"display\" cellspacing=\"0\">" << std::endl;
		htmlFile << "  <thead>" << std::endl;
		htmlFile << "    <tr>" << std::endl;
		htmlFile << "      <th>Evaluation</th>" << std::endl;
		htmlFile << "      <th>Game State</th>" << std::endl;
		htmlFile << "    </tr>" << std::endl;
		htmlFile << "  </thead>" << std::endl;
		htmlFile << "  <tbody>" << std::endl;
		for (auto simulation : node->simulations) {
			htmlFile << "    <tr>" << std::endl;
			htmlFile << "      <td>" << evaluationfunction->evaluate(simulation, globalMaxplayer) << "</td>" << std::endl;
			htmlFile << "      <td><pre>" << simulation.toString() << "</pre>" << std::endl;
			htmlFile << "    </tr>" << std::endl;
		}
		htmlFile << "  </tbody>" << std::endl;
		htmlFile << "</table>" << std::endl;
	}

	htmlFile << "</div>" << std::endl;

	// print children nodes
	for (auto childNode : node->children) {
		HTMLoutput::printMCTSCDnode(childNode);
	}
}

void HTMLoutput::closeFile()
{
	htmlFile << "</body>" << std::endl;
	htmlFile << "</html>" << std::endl;
	htmlFile.close();
}