#pragma once
#include "AbstractOrder.h"
#include "Common.h"
#include "Utils/DebugMemory.h"

class CombatSimulator;

class GameState
{
public:
	enum BuildingOption {
		NoneBuilding,
		ResourceDepot,
		AllBuildings
	};

	struct army_t {
		unitGroupVector friendly;
		unitGroupVector enemy;
	};

	typedef std::map<int, army_t> regionToArmy;

	GameState(); // by default uses CombatSimulatorBasic TODO remove this to enforce a combat simulator
	GameState(CombatSimulator* combatSim);
	GameState(const GameState &gameState); // copy constructor

	~GameState();

	const GameState& operator=(const GameState& gameState); // assignment operator

    int _buildingTypes;
	army_t army;
	std::set<int> regionsInCombat;
	regionToArmy combats;
	int _time;
	CombatSimulator* cs;

// 	void cleanData();
	void cleanArmyData();
	void loadIniConfig();
	void importCurrentGameState();
    void addAllEnemyUnits();
    void addSelfBuildings();
	unsigned short addFriendlyUnit(BWAPI::Unit unit);
	void addGroup(int unitId, int numUnits, int regionId, int listID, int orderId = abstractOrder::Unknown, int targetRegion = 0, int endFrame = 0);
	void addUnit(int unitId, int regionId, int listID, int orderId = abstractOrder::Unknown);
	unsigned short addUnitToArmySide(unitGroup_t* unit, unitGroupVector& armySide);
    void calculateExpectedEndFrameForAllGroups();
	int getAbstractOrderID(int orderId, int currentRegion, int targetRegion);
	const std::string getAbstractOrderName(BWAPI::Order order, int currentRegion, int targetRegion);
	const std::string getAbstractOrderName(int abstractId);
	std::string toString();
	
	void execute(playerActions_t playerActions, bool player);
	bool canExecuteAnyAction(bool player);
    void moveForward(int forwardTime = 0);
	int winner();
    bool gameover();
	bool hasOnlyBuildings(unitGroupVector armySide);
	GameState cloneIssue(playerActions_t playerActions, bool player);
    void mergeGroups();

    void resetFriendlyActions();
    BWAPI::Position getCenterRegionId(int regionId);
    int getRegionDistance(int regId1, int regId2);

	void compareAllUnits(GameState gs, int &misplacedUnits, int &totalUnits);
	void compareFriendlyUnits(GameState gs, int &misplacedUnits, int &totalUnits);
	void compareEnemyUnits(GameState gs, int &misplacedUnits, int &totalUnits);
	float getJaccard(GameState gs);
	float getJaccard2(GameState initialState, GameState finalState, bool useKillScore);

	void changeCombatSimulator(CombatSimulator* newCS);

private:
	std::vector<int> regionsToDelete;

	void updateCombatList();
	void setAttackOrderToIdle(unitGroupVector &army);
	int getMoveTime(int unitTypeId, int regionId, int targetRegionId);
    void calculateCombatTimes();
	inline void updateCombatLengthAtRegion(int regionID, bool lateDelete = false);
	void compareUnits(unitGroupVector units1, unitGroupVector units2, int &misplacedUnits, int &totalUnits);
	void compareUnits2(unitGroupVector units1, unitGroupVector units2, int &intersectionUnits, int &unionUnits);
	void compareUnitsWithWeight(unitGroupVector unitsWeight, const double K, bool useKillScore,
		unitGroupVector units1, unitGroupVector units2, double &intersectionUnits, double &unionUnits);
};
