#include "EvaluationFunctionBasic.h"
#include "InformationManager.h"

float EvaluationFunctionBasic::evaluate(const GameState &gs, bool isMaxPlayer)
{
    float score = 0.0f;

    // set maxplayer/minplayer UnitsList depends on the player;
	const unitGroupVector* maxUnits = &gs.army.friendly;
	const unitGroupVector* minUnits = &gs.army.enemy;

	if (!isMaxPlayer) {
        maxUnits = &gs.army.enemy;
        minUnits = &gs.army.friendly;
    }

	for (std::vector<int>::size_type i = 0; i < maxUnits->size(); ++i) {
		score += BWAPI::UnitType((*maxUnits)[i]->unitTypeId).destroyScore() * (*maxUnits)[i]->numUnits;
    }

	for (std::vector<int>::size_type i = 0; i < minUnits->size(); ++i) {
        score -= BWAPI::UnitType((*minUnits)[i]->unitTypeId).destroyScore() * (*minUnits)[i]->numUnits;
    }

    return score;
}