#pragma once

#include "Utils/DebugMemory.h"

// TODO killed units don't count their DPF (i.e. the survivor's DPF are overestimated)
// TODO loaded units shouldn't count to enemy DPF (neither their HP)
// Damage done split equally to all unit types (even if they don't participate in the combat)
// DPF calculated wrong when we have units which don't take part into the combat. Example: 1 marine + 8 SCV vs 1 SCV
// Spider mines damage added to Vultures?
// We don't take into account Medics (they can heal) (SCVs can repair)
// If the unit cannot attack air or ground (bunker, spell caster, transporters!!!, ...) we consider that can attack both types
// TODO transporter shouldn't be considered as "can attack both types" (see previous comment)
// Check "Damage done without units". Probably friend damage

class DpsLearner
{
public:
	struct stats {
		double totalDamage;
		int totalTime;
		int numCombats;
		double DPF;
		stats() : totalDamage(0.0), totalTime(0), numCombats(0), DPF(0.0){}
	};

	struct DPFtype {
		double air;
		double ground;
		double both;
		DPFtype() : air(0.0), ground(0.0), both(0.0){}
	};

	struct HPtype {
		int air;
		int ground;
		HPtype() : air(0), ground(0){}
	};

	struct unitInfo {
		int ID;
		std::string typeName;
		int typeID;
		int HP;
		int shield;
		int x;
		int y;
		unitInfo() : ID(0), typeName(""), typeID(BWAPI::UnitTypes::None), HP(0), shield(0){}
	};

	struct unitKilledInfo {
		int unitID;
		int frame;
	};

	struct bordaCountFrequency {
		int score;
		int frequency;
		bordaCountFrequency() : score(0), frequency(0){}
	};

	struct combatInfo {
		int startFrame, endFrame;
		std::map<BWAPI::UnitType, int> armySize1, armySize2;
		// <unitID, unitInfo>
		std::map<int, unitInfo> armyUnits1, armyUnitsEnd1, armyUnits2, armyUnitsEnd2;
		std::vector<unitKilledInfo> kills;
	};

	enum Matchups { TVT, TVP, TVZ, PVP, PVZ, ZVZ, NONE };
	struct DPFstats {
		int noCases;
		int size;
		DPFstats() : noCases(0), size(0){}
	};

	std::vector<std::vector<stats> > unitTypeDPF;
	std::vector<std::vector<stats> > unitTypeDPFbwapi;
	std::vector<DPFtype> unitDPF;
	std::vector<DPFtype> unitDPFbwapi;
	std::vector<HPtype> unitHPbwapi;
	std::vector<combatInfo> allCombats;
	std::vector<float> typePriority;
	std::vector<bordaCountFrequency> bordaCount;

	int combatsProcessed;
	std::map<Matchups, DPFstats> DPFcases;
	std::map<Matchups, int> DPFbounded;

	int armyDestroyed;
	int armyReinforcement;
	int armyPeace;
	int armyGameEnd;
	// corrupted games
	int moreThanTwoArmies;
	int armyKilledWithoutKills;

	DpsLearner();

	void parseReplayData(std::string replayFolder);
	void calculateDPS(bool skipTransports, bool onlyOneType);
	void calculateDPS(std::vector<combatInfo> combats, int* indices, int indexToSkip);
	void damageUpperBound();
	void calculatePriorityFirstBorda();
	void calculatePriorityLastBorda();
	// TODO we need a method to save and load learned variables instead of learn it each time
	void clear();
	std::string getMatchupName(Matchups matchId);

private:
	enum ParserState { COMBAT_START, ARMIES, KILLS };
	
	std::map<std::string, BWAPI::UnitType> getUnitTypeID;

	void unitKilled(unitKilledInfo killed, int &lastFrame, std::map<int, unitInfo> armyUnits,
		int sizeArmyCanAttackGround, int sizeArmyCanAttackAir, int sizeArmyCanAttackBoth,
		std::map<BWAPI::UnitType, int> armySizeAttacking, std::map<BWAPI::UnitType, int> &armySizeDefending,
		int &sizeArmyCanAttackGround2, int &sizeArmyCanAttackAir2, int &sizeArmyCanAttackBoth2);
	int getUnitTypefromID(combatInfo combat, int unitID);
	Matchups getMatchupType(BWAPI::UnitType type1, BWAPI::UnitType type2);
};
