#pragma once
#include "GameState.h"
#include "CombatSimulator.h"
#include "DpsLearner.h"
#include "Utils/DebugMemory.h"

// We compute the DPS and the HP as a whole for each army
// We don't consider individual HP, always using max
// We don't consider AOE damage
// We remove unit during combat, when a unit is removed, we update the overall new DPS and HP
// The target selection is sequential from the vector (i.e. the order is arbitrary)
// The minimum time to kill a unit is at least the minimum cooldown in the army group (this has been disable!! problems with both units killed)
// We don't allow "multi-attack", i.e. :
//  1 - all units in the army focus their attacks to the same target
//  2 - if you cannot attack a target (flying?) but you can attack another, you lost your turn to attack
// TODO spell casters have special DPS!!!!
// We don't consider upgrades for DPS
// TODO combat time is from CombatSimulatorBASIC (method 1)
//   - to get the combat length we actually need to simulate the combat: store the result of the combat to avoid re-simulate

typedef std::vector<std::vector<DpsLearner::stats> > dpfStats;

class CombatSimulatorDPS : public CombatSimulator
{
public:
	CombatSimulatorDPS();
	CombatSimulatorDPS(dpfStats* unitTypeDPF);
	virtual ~CombatSimulatorDPS() {}
	CombatSimulatorDPS * clone() const { return new CombatSimulatorDPS(*this); } // Virtual constructor (copying) 

	int getCombatLength(GameState::army_t* army);
	void simulateCombat(GameState::army_t* armyInCombat, GameState::army_t* army, int frames = 0);

private:
	struct combatStats_t {
		double airDPF; // DPF = Damage Per Frame
		double groundDPF;
		double airHP;
		double groundHP;
		combatStats_t() :airDPF(0), groundDPF(0), airHP(0), groundHP(0){}
	};

	dpfStats* _unitTypeDPF;

	void updateCombatStats(combatStats_t &combatStats, BWAPI::UnitType unitType, uint8_t numUnits);
	int getCombatLength(combatStats_t friendStats, combatStats_t enemyStats, int &timeToKillEnemy);
	combatStats_t getCombatStats(const UnitStateVector &army);

	double getTimeToKillUnit(const UnitStateVector &unitsInCombat, BWAPI::UnitType enemyType, int enemyHP, double &DPF);
	bool killUnit(UnitStateVector::iterator &unitToKill, UnitStateVector &unitsInCombat, UnitStateVector* unitsList, int &HPsurvivor, int &HPkilled, double timeToKill, double DPF);
	void removeUnit(unitGroup_t* unitToRemove, UnitStateVector* unitsList);

};