#pragma once
#include "GameState.h"
#include "CombatSimulator.h"
#include "DpsLearner.h"
#include "Utils/DebugMemory.h"

// HP details:
//	- using max HP and max shield
//  - not considering armor
// DPS details:
//	- not considering AOE damage
//	- not considering damage type
//  - not considering upgrades
// Each army produce full DPS through all the combat (we don't remove DPS on unit destroy)
// We remove units from the survivor army from their order in the vector (which is arbitrary)
// TODO Units that can attack air and ground units count twice!!!
// TODO spell casters have special DPS!!!!

class CombatSimulatorBasic : public CombatSimulator
{
public:
	CombatSimulatorBasic();
	CombatSimulatorBasic(std::vector<DpsLearner::DPFtype> *newUnitDPF, std::vector<DpsLearner::HPtype> *newUnitHP);
	virtual ~CombatSimulatorBasic() {}
	CombatSimulatorBasic * clone() const { return new CombatSimulatorBasic(*this); } // Virtual constructor (copying) 
	
	int getCombatLength(GameState::army_t* army);
	void simulateCombat(GameState::army_t* armyInCombat, GameState::army_t* army, int frames = 0);

private:
	struct combatStats_t {
		double airDPF; // DPF = Damage Per Frame
		double groundDPF;
		double bothDPF;
		double airHP;
		double groundHP;
		combatStats_t() :airDPF(0.0), groundDPF(0.0), bothDPF(0.0), airHP(0.0), groundHP(0.0){}
	};

	std::vector<DpsLearner::DPFtype> *unitDPF;
	std::vector<DpsLearner::HPtype> *unitHP;

	int getCombatLength(combatStats_t friendStats, combatStats_t enemyStats, int &timeToKillEnemy);
	combatStats_t getCombatStats(const UnitStateVector &army);
	void removeAllUnitsFromArmy(UnitStateVector* loserInCombat, UnitStateVector* loserUnits);
	void removeSomeUnitsFromArmy(UnitStateVector* winnerInCombat, UnitStateVector* winnerUnits, combatStats_t* loserStats, double frames);
};