#pragma once
#include "GameState.h"
#include "Utils/DebugMemory.h"

typedef std::vector<unitGroup_t*> UnitStateVector;

class CombatSimulator
{
public:
	virtual ~CombatSimulator() {}                 // Native support for polymorphic destruction.
	virtual CombatSimulator * clone() const = 0;  // Virtual constructor (copying) 

	virtual int getCombatLength(GameState::army_t* army) = 0;
	virtual void simulateCombat(GameState::army_t* armyInCombat, GameState::army_t* army, int frames = 0) = 0;
	bool canSimulate(GameState::army_t* armyInCombat, GameState::army_t* army)
	{
		// sanity check, if one of the lists is empty, we cannot simulate the combat
		if (armyInCombat->friendly.empty() || armyInCombat->enemy.empty() || army->friendly.empty() || army->enemy.empty()) {
// 			DEBUG("One of the combat sets is empty, combat simulation impossible");
			return false;
		}
		return true;
	}
};