#pragma once
#include <BWTA.h>

#include "AbstractOrder.h"
#include "GameState.h"
#include "Utils/DebugMemory.h"

class ActionGenerator
{
public:
	GameState* _gs;
	double _size;
	bool _player; // true==friendly, false==enemy
	playerActions_t _lastAction;

	ActionGenerator();
	ActionGenerator(GameState* gs, bool player=true);
	void cleanActions();
	playerActions_t getNextAction();
    playerActions_t getRandomAction();
	std::string toString();
	static std::string toString(playerActions_t playerActions);
    bool hasMoreActions() { return (_moreActions && !_choices.empty()); }

    double getHighLevelFriendlyActions();
    double getHighLevelEnemyActions();
    double getLowLevelFriendlyActions();
    double getLowLevelEnemyActions();
    double getSparcraftFriendlyActions();
    double getSparcraftEnemyActions();

private:
	std::vector<unitGroup_t*>* _myUnitsList;
	std::vector<unitGroup_t*>* _enemyUnitsList;
	choices_t _choices;
	std::vector<int> _choiceSizes;
    std::vector<int> _currentChoice;
	bool _moreActions;

	std::vector<action_t> getUnitActions(unitGroup_t* unit);
	void incrementCurrentChoice(unsigned int startPosition);

    double getHighLevelActions(std::vector<unitGroup_t*> unitList);
    double getLowLevelActions(BWAPI::Unitset units);
    double getSparcraftActions(BWAPI::Unitset units);
};
