#pragma once
#include "Utils/DebugMemory.h"

#define DEBUG_ORDERS

struct unitGroup_t {
	uint8_t unitTypeId;
	uint8_t numUnits;
	uint8_t regionId;
	uint8_t orderId;
	uint8_t targetRegionId;
	int endFrame; // expected frame where the order is done

	unitGroup_t(uint8_t unit, uint8_t size, uint8_t region, uint8_t order, uint8_t targetRegion)
		:unitTypeId(unit), numUnits(size), regionId(region), orderId(order), targetRegionId(targetRegion), endFrame(0){}
	unitGroup_t(uint8_t unit, uint8_t size, uint8_t region, uint8_t order, uint8_t targetRegion, int frame)
		:unitTypeId(unit), numUnits(size), regionId(region), orderId(order), targetRegionId(targetRegion), endFrame(frame){}
};
typedef std::vector<unitGroup_t*> unitGroupVector;

struct action_t {
	uint8_t orderID;
	uint8_t targetRegion; // if needed
	action_t(uint8_t _orderID, uint8_t _targetRegion = 0) : orderID(_orderID), targetRegion(_targetRegion) {}
};

struct choice_t {
	unsigned short pos;	// position in the unit vector of the game state
	std::vector<action_t> actions;
#ifdef DEBUG_ORDERS
	uint8_t unitTypeId;
	uint8_t regionId;
	bool isFriendly;
	choice_t(unsigned short _pos, std::vector<action_t> _actions, uint8_t _unitTypeId, uint8_t _regionId, bool _isFriendly)
		: pos(_pos), actions(_actions), unitTypeId(_unitTypeId), regionId(_regionId), isFriendly(_isFriendly) {}
#else
	choice_t(unsigned short _pos, std::vector<action_t> _actions) : pos(_pos), actions(_actions) {}
#endif
};
typedef std::vector<choice_t> choices_t;

struct playerAction_t {
	unsigned short pos;	// position in the unit vector of the game state
	action_t action;
	playerAction_t() : pos(0), action(action_t(0, 0)) {}
#ifdef DEBUG_ORDERS
	uint8_t unitTypeId;
	uint8_t regionId;
	bool isFriendly;
	playerAction_t(choice_t order, int orderSelected)
		: pos(order.pos), action(order.actions[orderSelected]), unitTypeId(order.unitTypeId), regionId(order.regionId), isFriendly(order.isFriendly) {}
#else
	playerAction_t(choice_t order, int orderSelected)
		: pos(order.pos), action(order.actions[orderSelected]) {}
#endif
};
typedef std::vector<playerAction_t> playerActions_t;

namespace abstractOrder {
	static enum abstractOrder {
		Unknown, Nothing, Idle, Gas, Mineral, Move, Attack, Heal
	};

	static std::string name[8] = {
		"Unknown", "Nothing", "Idle", "Gas", "Mineral", "Move", "Attack", "Heal"
	};

	static abstractOrder getOrder(std::string orderName) {
		if (orderName.find("Nothing") != std::string::npos) return abstractOrder::Nothing;
		else if (orderName.find("Idle") != std::string::npos) return abstractOrder::Idle;
		else if (orderName.find("Gas") != std::string::npos) return abstractOrder::Gas;
		else if (orderName.find("Mineral") != std::string::npos) return abstractOrder::Mineral;
		else if (orderName.find("Move") != std::string::npos) return abstractOrder::Move;
		else if (orderName.find("Attack") != std::string::npos) return abstractOrder::Attack;
		else if (orderName.find("Heal") != std::string::npos) return abstractOrder::Heal;
		else return abstractOrder::Unknown;
	}
};
