#pragma once
#include <iostream>
#include <queue>
#include <BWAPI.h>

#include "Common.h"
#include "InformationManager.h"
#include "Utils/DebugMemory.h"

class PlannerManager
{
public:
	PlannerManager();
	void setBalance(UnitToPercent percentList);
	void onFrame();
	void rebalanceProduction();
	void updateSelfArmy();
	void updateEnemyArmy();
	void updateSelfArmyStats(BWAPI::UnitType type, double size);
	void updateEnemyArmyStats(BWAPI::UnitType type, double size);


	UnitToPercent _percentList;

};

// class for priority queue
class UnitTypePercent
{
public:
	BWAPI::UnitType type;
	double percent;
	// constructors
	UnitTypePercent() {};
	UnitTypePercent(BWAPI::UnitType x, double y) { type = x; percent = y; }
	//overloaded < operator
	bool operator<(const UnitTypePercent&) const;
};