#pragma once
#include <BWTA.h>

#include <QtGui> // including <QtGui> saves us to include every class user, <QString>, <QFileDialog>,...
#include "GUI/GeneratedFiles/ui_QtWindow.h"
#include "GUI/QSignal.h"
#include "GUI/CustomItems.h"

#include "Search/ActionGenerator.h"

#include "Utils/DebugMemory.h"

#include "Search/DpsLearner.h"
#include "SparCraft.h"

class myQtApp : public QWidget, private Ui::myQtAppDLG
{
	Q_OBJECT

public:
	myQtApp(QWidget *parent = 0);
	~myQtApp();

	QGraphicsScene * mapScene;
	int regionIdSelected;

public slots:
	// Options
	void changeSpeed(int value);
	void pauseGame();
	void resumeGame();

	void changeDisplayBWTA(int state);
	void changeBuildMap(int state);
	void changeGroundDPS(int state);
	void changeAirDPS(int state);
	void changeBuildOrder(int state);
	void changeRegionId(int state);

	// Game State
	void changeBWTAdata();
	void drawPolygons(const std::set<BWTA::Polygon*>* polygons, QGraphicsScene* scene);
	void drawPolygon(BWTA::Polygon& p, QColor qc, QGraphicsScene* scene, double scale = 1);
	void drawCustomPolygon(BWTA::Polygon& p, QGraphicsScene* scene, int regionId);
	void updateGameStateTable();
	void gameStateTabChanged(int tabIndex);
	void updateUnitMap();
	void updateUnitTable();
	void drawUnitEllipse(int x, int y, int xOffset, QColor color, int regionId, QGraphicsScene* scene);
	void updateEffectivenessMap();
	void drawCircleText(int x, int y, int xOffset, QColor color, int regionId, QGraphicsScene* scene);

	// Game Search
	void importState();
	void loadFile();
	void abcdSearch();

	void generateActions();
	void expandNode();
    void expandRandomNode();
	void executeAction();
	void rolloutGame();
    
	GameState getGameState(SparCraft::GameState sparCraftGameState);
	void addUnitsFromReplaytoGameState(std::map<int, DpsLearner::unitInfo> armyUnits, GameState &myGameState, SparCraft::GameState &sparCraftState,
		int playerID, bool &hasMines, bool &hasDropships, bool &skipSparCraft,
		bool SKIP_DROPSHIPS, bool ONLY_SPARCRAFT_SUPPORTED);

	BWAPI::Position getCenterRegionId(int regionId);

	// Combat simulator
	void parseCombats();
	void clearCombatsParsed();
	void learnCombat();
	void getDPF();
	void combatSimulator();

private:
	// Tab BWTA -> Game State
	QStringList gameStateLabels;
	QStringList unitMapLabels;

	std::string spacePartition;

	GameState testGameState;
	ActionGenerator testActions;

	void printError(QTextEdit * textEdit, const QString & text);

	DpsLearner learner;
	void crossValidation();
};
