#pragma once
#include <BWAPI.h>
#include <limits>
#include <cmath>
#include <set>

#ifdef NOVA_GUI
#include <mutex>
#include "GUI/QtWindow.h"
#endif

typedef unsigned char uint8_t;

typedef std::set<BWAPI::TilePosition> TilePositionSet; //TODO use BWAPI::VectorSet??
typedef std::map<BWAPI::UnitType, int> UnitToPercent;

// Display debug info on screen
#define DEBUG_DISPLAY 1

// Managers:
class InformationManager;
class WorkerManager;
class SquadManager;
class BuildManager;
class WallGenerator;
class ProductionManager;

// Initialized in NovaAIModule::onStart();
extern InformationManager* informationManager;
extern WorkerManager* workerManager;
extern SquadManager* squadManager;
extern BuildManager* buildManager;
extern WallGenerator* wallGenerator;
extern ProductionManager* productionManager;

#ifdef NOVA_GUI
extern std::mutex gameStateMutex;
extern QApplication QtApp;
extern myQtApp* novaGUI;
#endif

extern bool ONLY_MICRO;
extern bool PRINT_BUILD_ORDER;
extern bool PRINT_AIR_DPS;
extern bool PRINT_GROUND_DPS;
extern bool PRINT_PRODUCTION;
extern bool PRINT_BUILD_MAP;
extern bool PRINT_REGION_ID_MAP;
extern bool PRINT_SIEGE_MAP;

extern bool HIGH_LEVEL_SEARCH;
extern std::string SEARCH_ALGORITHM;
#define GAME_STATE_REFRESH 70  // in game frames
extern int HIGH_LEVEL_REFRESH; //in game frames

extern bool usingCloackUnits;
extern bool usingCloackUnits;
extern int totalKitingFrames;
extern bool kitingFrame;

BWAPI::Position rotatePosition(int degree, BWAPI::Position position, BWAPI::Position origen);
BWAPI::Position getPositionInDirection(BWAPI::Position origen, BWAPI::Position direction, int distance);
std::vector<std::string> &splitString(const std::string &s, char delim, std::vector<std::string> &elems);
std::vector<std::string> splitString(const std::string &s, char delim);
std::string intToString(const int& number); // TODO we don't need this with C++11
// TODO make this way to check canAttackAir standard
bool canAttackAirUnits(BWAPI::UnitType unitType);
bool canAttackGroundUnits(BWAPI::UnitType unitType);
bool canAttackType(BWAPI::UnitType unitTypeAttacking, BWAPI::UnitType unitTypeTarget);

#include "Utils/WalkPosition.h"

// High level search stats
struct HighLevelStats_t {
	std::map<unsigned int, double> groupTime;
	std::map<unsigned int, unsigned long> groupFrequency;
    std::map<unsigned int, double> groupBranchingMin;
    std::map<unsigned int, double> groupBranchingMax;
    std::map<unsigned int, double> groupBranchingAvg;
    std::map<unsigned int, unsigned long> groupTimeouts;
    std::map<unsigned int, unsigned long> groupDownSamplings;
    unsigned int orders;
    unsigned int ordersOverwritten;
	std::map<unsigned int, unsigned long> stateChange;
	unsigned int lastFrameStateChange;
};

extern HighLevelStats_t stats;
extern const bool HighLevelChangeRateExperiment;

// --- INI config functions
extern std::string configPath;
std::string LoadConfigString(const char *pszKey, const char *pszItem, const char *pszDefault = NULL);
int LoadConfigInt(const char *pszKey, const char *pszItem, const int iDefault = 0);