#ifndef _ASSERT_H_
#define _ASSERT_H_

// Configuration
#define NASSERT_ENABLED

#define NASSERT_LOG(msg) do{ DEBUG(msg); } while(false)

// Assertions
#define NASSERT_NOOP(x) do{ (void)sizeof(x); } while(false) 
#define NASSERT_HALT() __debugbreak()

#if defined(NASSERT_ENABLED)
	#define NASSERT(cond) \
		do { if(!(cond)){ NASSERT_LOG("[ASSERT FAIL]");  NASSERT_HALT(); } } while(false)

	#define NASSERT_EX(cond, msg) \
		do { if(!(cond)) { NASSERT_LOG("[ASSERT FAIL]" << msg); NASSERT_HALT(); } } while(false)
#else
#define NASSERT(cond) NASSERT_NOOP(cond);
#define NASSERT_EX(cond, msg) NASSERT_NOOP(cond);
#endif

#endif