#include "EvaluationFunctionBasic.h"
#include "InformationManager.h"

float EvaluationFunctionBasic::evaluate(int maxplayer, int minplayer, GameState gs, int depth)
{
    float score = 0;

    // set maxplayer/minplayer UnitsList depends on the player;
    std::vector<GameState::unitState_t> maxUnits;
    std::vector<GameState::unitState_t> minUnits;
//     uint8_t maxBase;
//     uint8_t minBase;
//     BWAPI::TilePosition enemyPosition = (BWAPI::TilePosition)informationManager->_enemyStartPosition;
//     BWAPI::TilePosition myPosition = (BWAPI::TilePosition)BWTA::getStartLocation(BWAPI::Broodwar->self())->getPosition();
    if (maxplayer) {
        maxUnits = gs.friendlyUnits;
        minUnits = gs.enemyUnits;
//         maxBase = informationManager->_regionIdMap[myPosition.x()][myPosition.y()];
//         minBase = informationManager->_regionIdMap[enemyPosition.x()][enemyPosition.y()];
    } else {
        maxUnits = gs.enemyUnits;
        minUnits = gs.friendlyUnits;
//         maxBase = informationManager->_regionIdMap[enemyPosition.x()][enemyPosition.y()];
//         minBase = informationManager->_regionIdMap[myPosition.x()][myPosition.y()];
    }

    for (unsigned int i=0; i < maxUnits.size(); i++) {
        score += BWAPI::UnitType(maxUnits[i].unitTypeId).destroyScore() * maxUnits[i].numUnits;
        // loosing points if we are far from the opponents base
        //score *= (float)(pow(0.999,gs.getRegionDistance(maxUnits[i].regionId, minBase)));
    }

    for (unsigned int i=0; i < minUnits.size(); i++) {
        score -= BWAPI::UnitType(minUnits[i].unitTypeId).destroyScore() * minUnits[i].numUnits;
        // loosing points if we are far from the opponents base
        //score *= (float)(pow(1.111,gs.getRegionDistance(minUnits[i].regionId, maxBase)));
    }

    // loosing points if we are far from the root
    score *= (float)(pow(0.999,depth));

    return score;
}

// return the evaluation in the range [0-1]
//float EvaluationFunctionBasic::evaluateBounded(int maxplayer, int minplayer, GameState gs, int depth)