#pragma once
#include "GameState.h"
#include "AbstractOrder.h"
#include <BWTA.h>

class ActionGenerator
{
public:
	GameState _gs;
	double _size;
	bool _player; // true==friendly, false==enemy
	playerActions_t _lastAction;

	ActionGenerator();
	ActionGenerator(GameState gs, bool player=true);
	void cleanActions();
	playerActions_t getNextAction();
    playerActions_t getRandomAction();
	std::string toString();
	std::string toString(playerActions_t playerActions);
    bool hasMoreActions() { return (_moreActions && !_choices.empty()); }

    double getHighLevelFriendlyActions();
    double getHighLevelEnemyActions();
    double getLowLevelFriendlyActions();
    double getLowLevelEnemyActions();
    double getSparcraftFriendlyActions();
    double getSparcraftEnemyActions();

private:
	std::vector<GameState::unitState_t> _myUnitsList;
	std::vector<GameState::unitState_t> _enemyUnitsList;
	choices_t _choices;
	std::vector<int> _choiceSizes;
    std::vector<int> _currentChoice;
	bool _moreActions;

	std::vector<action_t> getUnitActions(GameState::unitState_t unit);
	void incrementCurrentChoice(unsigned int startPosition);

    double getHighLevelActions(std::vector<GameState::unitState_t> unitList);
    double getLowLevelActions(UnitSet units);
    double getSparcraftActions(UnitSet units);
};
