#pragma once

namespace abstractOrder {
	enum {
		Unknown,
        Nothing,
		Idle,
		Gas,
		Mineral,
		Move,
		Attack,
		Heal
	};

	extern const std::string name[8];
};

// action_t is a tuple of an abstarctOrder and a targetRegion (if needed)
typedef std::pair<uint8_t, uint8_t> action_t;
// unit and action
typedef std::pair<unsigned int, std::vector<action_t> > choice_t;
typedef std::vector<choice_t> choices_t;
// unsigned int is the position in the unit vector of the game state
//typedef std::vector<std::pair<unsigned int, action_t> > playerActions_t;

// Packed as targetRegion, abstractOrder and groupID (position in the unit vector of the game state)
// (int) 00000000 TTTTTTTT AAAAAAAA GGGGGGGG
typedef std::vector<int> playerActions_t;
