#pragma once
#include <BWAPI.h>
#include "Common.h"
#include "InformationManager.h"
#include "WorkerManager.h"

class ProductionManager
{
public:
	ProductionManager();
	void onBuildingShow(BWAPI::Unit* unit);
	void onFrame();
	void onBuildingDestroy(BWAPI::Unit* unit);

	UnitSet _commandCenters;
	UnitSet _barracks;
	UnitSet _factories;
	UnitSet _starports;
	BWAPI::Unit* _academy;
	BWAPI::Unit* _engineeringBay;
	UnitSet _machineShop;
	UnitSet _controlTower;
	UnitSet _armory;
	BWAPI::Unit* _scienceFacility;
	BWAPI::Unit* _physicsLab;
	BWAPI::Unit* _covertOps;
	UnitSet _nuclearSilo;

private:
	bool canTrain(BWAPI::UnitType type);
	bool onProduction(UnitSet buildings);
	BWAPI::UnitType needAddon(BWAPI::UnitType toTrain);
	BWAPI::UpgradeType getNextArmoryUpgrade();
	BWAPI::UpgradeType getNextInfanteryUpgrade();
	BWAPI::Position getRallyPosition(BWAPI::Unit* unit);
	void printBlockedProduction(UnitSet buildings, std::string message, int &counter);
	void printBlockedProduction(BWAPI::Unit *unit, std::string message, int &counter);

	log4cxx::LoggerPtr _logger;

};