#pragma once
#include <QtGui> // including <QtGui> saves us to include every class user, <QString>, <QFileDialog>,...
#include "GUI/GeneratedFiles/ui_QtWindow.h"
#include "GUI/QSignal.h"
#include <BWAPI.h>
#include <BWTA.h>


class myQtApp : public QWidget, private Ui::myQtAppDLG
{
	Q_OBJECT

public:
	myQtApp(QWidget *parent = 0);

public slots:
	// Options
	void changeSpeed(int value);
	void pauseGame();
	void resumeGame();

	void changeDisplayBWTA(int state);
	void changeBuildMap(int state);
	void changeGroundDPS(int state);
	void changeAirDPS(int state);
	void changeBuildOrder(int state);
	void changeRegionId(int state);

	// Game State
	void changeBWTAdata();
	void drawPolygons(const std::set<BWTA::Polygon*>* polygons, QGraphicsScene* scene);
	void drawPolygon(BWTA::Polygon& p, QColor qc, QGraphicsScene* scene, double scale = 1);
	void updateGameStateTable();
	void gameStateTabChanged(int tabIndex);
	void updateUnitMap();
	void drawUnitEllipse(int x, int y, int xOffset, QColor color, int regionId, QGraphicsScene* scene);
	void updateEffectivenessMap();
	void drawCircleText(int x, int y, int xOffset, QColor color, int regionId, QGraphicsScene* scene);

	// Game Search
	void cleanActions();
	void generateActions();
	void expandNode();
    void expandRandomNode();
	void executeAction();
    void loadFile();

	BWAPI::Position getCenterRegionId(int regionId);

private:
	QGraphicsScene * mapScene;

	// Tab BWTA -> Game State
	QStringList gameStateLabels;
	QStringList unitMapLabels;
};


class CustomEllipseItem : public QGraphicsEllipseItem
{
public:
	int regionId;
protected:
	void mousePressEvent(QGraphicsSceneMouseEvent *event);
};