#ifndef _TYPED_COMPONENT_H_
#define _TYPED_COMPONENT_H_

#include "Component.h"
#include "ComponentType.h"

namespace ComponentSystem
{
	template<ComponentType type>
	class TypedComponent : public Component
	{
	public:
		virtual void update() = 0;
		ComponentType getType();
	protected:
		static ComponentType type();
	}

	/////////////////////////////////////////////////////////////////////////////////
	// DEFINITIONS
	/////////////////////////////////////////////////////////////////////////////////
	template<ComponentType type>
	ComponentType TypedComponent<type>::getType()
	{
		return type();
	}


	template<ComponentType type>
	ComponentType TypedComponent<type>::type()
	{
		return type;
	}

}


#endif