#pragma once
#include <BWAPI.h>
#include "Common.h"
#include "InformationManager.h"
#include "CombatAgents/InterfaceBehaviour.h"

class CombatAgent
{
public:
	CombatAgent(BWAPI::Unit* unit, class SquadAgent *squad);
	~CombatAgent();

	InterfaceBehaviour* behaviour;

	void defaultBehaviour();
	void onGetPosition(BWAPI::Position targetPosition);
    void onGetNewPosition(BWAPI::Position targetPosition);
	void onStop();
	void onHold();
	void inCombat(const UnitSet &enemies, class SquadAgent *squad);
	void inCombatBiological(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);

	double computeTargetScore(BWAPI::Unit* target);
	double dps(BWAPI::Unit *unit, BWAPI::Unit *target);
	double tacticalThreat(BWAPI::Unit *unit, BWAPI::Unit *target);

	BWAPI::Unit* _unit;
	BWAPI::Unit* _lastTarget;
	bool _inCooldown;
	BWAPI::Position _lastPosition;
	int frameCreated;

	int getEnemiesInRange(const UnitSet &enemies);


private:
	log4cxx::LoggerPtr _logger;

	bool onlyBuildingEnemies(const UnitSet &enemies);
	void isTankNear(BWAPI::Unit *bestTarget, class SquadAgent *squad);
	bool protectTank(BWAPI::Unit *bestTarget, class SquadAgent *squad);
};