#pragma once
#include <algorithm>
#include <BWAPI.h>
#include "Common.h"
#include "InformationManager.h"
#include "WorkerManager.h"

typedef std::set<BWAPI::TilePosition> TilePositionSet;
typedef std::vector<BWAPI::UnitType> UnitTypeVector;

struct MyRectangle {
	int x1;
	int y1;
	int x2;
	int y2;
};

class BuildManager
{
public:
	BuildManager();
	~BuildManager();
	void onFrame();
	BWAPI::TilePosition BuildManager::getBuildLocationNear(BWAPI::TilePosition position, BWAPI::UnitType type, BWTA::Region* inRegion = 0);
	void constructionPlaced(BWAPI::Unit* build);
	void refineryPlaced(BWAPI::Unit* build);
	void onBuildingDestroy(BWAPI::Unit* build);
	bool alreadyBuilding(BWAPI::UnitType type);
	bool alreadyRequested(BWAPI::UnitType type);
	bool wallNear(BWAPI::TilePosition destination);
	void reserveBaseLocations();

	UnitTypeVector _buildOrder;
	UnitTypeVector _toConstruct;

private:
	bool executeBuildOrder(BWAPI::UnitType buildType);
	BWAPI::TilePosition getGeyserTilePosition();
	bool needSupply();
	bool buildOnProxy(BWAPI::UnitType type);
	BWAPI::TilePosition getSeedForTurret();
	MyRectangle getBuildRectangle(BWAPI::TilePosition position, BWAPI::UnitType type);
	void mapArea(MyRectangle c, int label, int expand=0);
	bool canBuildHere(BWAPI::TilePosition buildPosition, BWAPI::UnitType type);
	bool anyMissileTurretsNear(BWAPI::TilePosition buildPosition);
	void drawBuildMap();
	void drawBuildOrder();
	bool canBuild(BWAPI::UnitType type);

	BWAPI::Unit* _workerBuildingRefinery;
	int mapW;
	int mapH;
	int** buildMap;

};