/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Worker Manager Singleton.
*/

#include "CommonIncludes.h"

#include <unordered_map>

#include "Base.h"
#include "Task.h"
#include "TaskSet.h"
#include "UnitOwner.h"
#include "UnitUtils.h"

class WorkerManager : public UnitOwner
{
public:
	// Returns pointer to singleton instance
	static WorkerManager* Instance()
	{
		static WorkerManager instance;
		static WorkerManager* instance_ptr = &instance;
		return instance_ptr;
	}

	void baseUnderAttack(const Base& base);
	void noDefenseNeeded();
	const size_t numDefendersNeeded();

	void receiveOwnership(const BWAPI::Unit unit);
	void removeOwnership(const BWAPI::Unit unit);

	const BWAPI::Unitset getPotentialTargets(BWAPI::Unit squadMember) const;

	// EVENTS
	void onFrame();

	BWAPI::Unit requestBuilder(const BWAPI::TilePosition buildPos);
	BWAPI::Unit requestScout();

private:
	std::unordered_map<BWAPI::Unit, TaskSet, UnitUtils::HashFunctionUnit> unitTasksMap;
	BWAPI::Unitset currentDefenders;
	BWAPI::Unit lastWorkerReceived;
	size_t defendingProbesNeeded;

	WorkerManager() :
	  UnitOwner(), unitTasksMap(), currentDefenders(), lastWorkerReceived(nullptr), defendingProbesNeeded(0) {}

	Task* requestNewWorkerTask(BWAPI::Unit worker);

	WorkerManager(WorkerManager const &);
};