/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Utility functions and typedefs to make std::vector easier to use

	TODO: use memcpy/memset?
*/

#include <algorithm>
#include <vector>

#include "Predicates.h"

namespace VectorUtils
{
	// creates a vector from a given array and a given array size
	template <typename T> 
	static std::vector<T>	array_to_vector(T arr[], size_t size);

	// appends all elements in v2 to the end of v1
	template <typename T>
	static void				append(std::vector<T>& v1, const std::vector<T>& v2);

	// fills a given vector with n times a given value. If the vector is currently filled, will clear it first!
	template <typename T>
	static void				fillVector(std::vector<T>& v, const size_t n, const T value);

	// Removes all elements from a given vector for which a given predicate holds, and returns the removed elements in a new vector
	template <typename T, typename Pred>
	static std::vector<T>	popFromVectorIfNot(std::vector<T>& v, Pred pred);

	template <typename T>
	void					removeFromVector(std::vector<T>& v, T value);

	// Removes all elements from a given vector for which a given predicate holds
	template <typename T, typename Pred>
	static void				removeFromVectorIf(std::vector<T>& v, Pred pred);
}

/*	==========================================================================================
			Definition of declarations above

			Implementing short functions in header file
			Allows for better compiler optimizations through inlining
	========================================================================================== */

template <typename T> 
inline std::vector<T> VectorUtils::array_to_vector(T arr[], size_t size)
{
	return std::vector<T> (arr, arr + size);
}

template <typename T>
inline void VectorUtils::append(std::vector<T>& v1, const std::vector<T>& v2)
{
	v1.insert(v1.end(), v2.begin(), v2.end());
}

template <typename T>
void VectorUtils::fillVector(std::vector<T>& v, const size_t n, const T value)
{
	v.clear();
	v.reserve(n);
	for(size_t i = 0; i < n; ++i)
	{
		v.push_back(value);
	}
}

template <typename T, typename Pred>
std::vector<T> VectorUtils::popFromVectorIfNot(std::vector<T>& v, Pred pred)
{
	auto it = std::stable_partition(v.begin(), v.end(), pred);

	std::vector<T> popped;

	for(auto it_popped = it; it_popped != v.end(); ++it_popped)
	{
		popped.push_back(*it_popped);
	}

	v.erase(it, v.end());

	return popped;
}

template <typename T>
void VectorUtils::removeFromVector(std::vector<T>& v, T value)
{
	auto it = std::remove(v.begin(), v.end(), value);
	v.erase(it, v.end());
}

template <typename T, typename Pred>
void VectorUtils::removeFromVectorIf(std::vector<T>& v, Pred pred)
{
	auto it = std::remove_if(v.begin(), v.end(), pred);
	v.erase(it, v.end());
}