/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	This module allows processing of commands entered by the user through the in-game chat function, assuming
	that MAASCRAFT_DEBUG is defined

	If MAASCRAFT_DEBUG is not defined, the entire module will not be compiled.
*/

#pragma once

#include "CommonIncludes.h"

#ifdef MAASCRAFT_DEBUG

namespace UserCommandProcessor
{
	void onFrame();
	void processCommand(std::string& command);

	static const std::string KNOWN_COMMANDS[] = {
		"/clearDrawings",						// clears all drawings from this module
		"/dumpUnitInfo",						// writes info about a selected unit to the log file
		"/drawBaseLocations",					// draws all base locations in yellow
		"/drawChokePoints",						// draw all choke points as white lines
		"/drawMapGraph",						// draws a sparse graph laid over the map
		"/drawOpponentClusters",				// visualize opposing clusters
		"/drawPaths",							// draw paths from selected units to marked position
		"/drawReserved",						// indicates on the map which locations have been reserved by buildings
		"/drawWalkability",						// indicates on the map which locations are unwalkable according to MaasCraft
		"/drawThreatMap",						// writes the air and ground threat values on each tile position
		"/help",								// help function
		"/logRandomTraversal",					// log a random UCT traversal
		"/pause",								// pause/unpause the game
		"/setMarker",							// sets marker to be used by other commands
		"/verboseUCT"							// makes UCT dump game state info for the next search
	};

	static BWAPI::Position MARKED_POSITION = BWAPI::Position(0, 0);

	static bool DRAW_BASE_LOCATIONS = false;
	static bool DRAW_CHOKE_POINTS = false;
	static bool DRAW_MAP_GRAPH = false;
	static bool DRAW_OPPONENT_CLUSTERS = false;
	static bool DRAW_PATHS = false;
	static bool DRAW_RESERVED = false;
	static bool DRAW_THREAT_MAP = false;
	static bool DRAW_WALKABILITY = false;
	static bool PAUSED;
}

#endif	// MAASCRAFT_DEBUG