/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Utility functions for BWAPI Units
*/

#pragma once

#include "CommonIncludes.h"

namespace UnitUtils
{
	// class to save data on a given unit. Can be used to remember data on enemy units when they become inaccessible
	class UnitData
	{
	public:
		BWAPI::Position		lastPosition;
		int					id;
		int					lastHP;
		int					lastSeen;
		BWAPI::Unit			unitPtr;
		BWAPI::UnitType		unitType;
		bool				completed;

		UnitData() :
			lastPosition(BWAPI::Positions::None), id(0), lastHP(0), lastSeen(BWAPI::Broodwar->getFrameCount()),
			unitPtr(nullptr), unitType(BWAPI::UnitTypes::None), completed(false) {}

		UnitData(const int id, const int lastHP, const BWAPI::Position& lastPosition, const BWAPI::Unit unitPtr, const BWAPI::UnitType unitType) :
			lastPosition(lastPosition), id(id), lastHP(lastHP), lastSeen(BWAPI::Broodwar->getFrameCount()),
			unitPtr(unitPtr), unitType(unitType), completed(unitPtr->isCompleted()) {}

		UnitData(const BWAPI::Unit unit) :
			lastPosition(unit->getPosition()), id(unit->getID()), lastHP(unit->getHitPoints()), lastSeen(BWAPI::Broodwar->getFrameCount()),
			unitPtr(unit), unitType(unit->getType()), completed(unitPtr->isCompleted()) {}

		inline const bool operator == (const UnitData& other) const
		{
			return (id == other.id);
		}
	};

	const bool canAttack(const BWAPI::Unit unit);
	const bool canMove(const BWAPI::Unit unit);

	const float dpsAir(const BWAPI::Unit unit);
	const float dpsAir(const UnitData& data);
	const float dpsGround(const BWAPI::Unit unit);
	const float dpsGround(const UnitData& data);
	const float dpsToTarget(const BWAPI::Unit attacker, const BWAPI::Unit target);
	const float damageToTarget(const BWAPI::Unit attacker, const BWAPI::Unit target);	// single hit damage

	const int hp(const BWAPI::Unit unit);
	const int hp(const UnitData& data);

	const int rangeAir(const BWAPI::Unit unit);
	const int rangeAir(const UnitData& data);
	const int rangeGround(const BWAPI::Unit unit);
	const int rangeGround(const UnitData& data);

	const bool isInCombat(const BWAPI::Unit unit);
	const bool isUnitValid(const BWAPI::Unit unit);

	const BWAPI::Unit getClosestUnit(const BWAPI::Position& center, const BWAPI::Unitset& units);
	const BWAPI::Unit getClosestUnit(const BWAPI::Unit unit, const BWAPI::Unitset& units);

	const BWAPI::Unit getClosestUnitInRadius(const BWAPI::Position& center, const int radius, const BWAPI::UnitFilter& pred = nullptr);
	const BWAPI::Unit getClosestUnitInRadius(const BWAPI::Unit unit, const int radius, const BWAPI::UnitFilter& pred = nullptr);

	const BWAPI::Unit getClosestUnitInRectangle(const BWAPI::Position& center, const int left, const int top, 
												const int right, const int bottom, const BWAPI::UnitFilter& pred = nullptr);

	const BWAPI::Unitset getUnitsInRadius(const BWAPI::Position& center, const int radius, const BWAPI::UnitFilter& pred = nullptr);
	const BWAPI::Unitset getUnitsInRadius(const BWAPI::Unit unit, const int radius, const BWAPI::UnitFilter& pred = nullptr);

	const BWAPI::Unitset getUnitsInWeaponRange(const BWAPI::Unit unit, const BWAPI::WeaponType weapon, const BWAPI::UnitFilter& pred = nullptr);
	const BWAPI::Unitset getUnitsInWeaponRange(const BWAPI::Unit unit, const BWAPI::WeaponType weapon, const BWAPI::Unitset& units);

	// Hash function for BWAPI::Unit
	struct HashFunctionUnit
	{
		size_t operator() (const BWAPI::Unit unit) const
		{
			return std::hash<int>()(unit->getID());
		}
	};

	// Hash function for BWAPI::UnitType
	struct HashFunctionUnitType
	{
		size_t operator() (const BWAPI::UnitType unitType) const
		{
			return std::hash<int>()(unitType.getID());
		}
	};
}