/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Unit Tracker Singleton.
*/

#include "CommonIncludes.h"

#include <unordered_map>

#include "UnitOwner.h"
#include "UnitUtils.h"

class UnitTracker
{
public:
	static UnitTracker* Instance()
	{
		static UnitTracker instance;
		static UnitTracker* instance_ptr = &instance;
		return instance_ptr;
	}

	UnitOwner* getUnitOwner(BWAPI::Unit unit) const;
	void setOwner(BWAPI::Unit unit, UnitOwner* owner);

	const BWAPI::Unitset& getSelfBuildings();
	const BWAPI::Unitset& getSelfArmyUnits();
	const BWAPI::Unitset& getSelfWorkerUnits();
	void validateSelfUnits();

	void assignWorkerToResource(BWAPI::Unit worker, BWAPI::Unit resource);
	const int getNumAssignedWorkers(BWAPI::Unit resource);
	void removeWorkerFromResource(BWAPI::Unit worker, BWAPI::Unit resource);

private:
	std::unordered_map<BWAPI::Unit, UnitOwner*, UnitUtils::HashFunctionUnit> unitsToOwners;
	std::unordered_map<BWAPI::Unit, BWAPI::Unitset> resourcesToAssignedWorkers;

	BWAPI::Unitset selfBuildings;
	BWAPI::Unitset selfArmyUnits;
	BWAPI::Unitset selfWorkerUnits;

	UnitTracker() : unitsToOwners(), resourcesToAssignedWorkers(), 
					selfBuildings(), selfArmyUnits(), selfWorkerUnits() {}
	~UnitTracker(){}

	UnitTracker(UnitTracker const &);
};