/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "CommonIncludes.h"

#include <unordered_map>

#include "MapAnalyser.h"
#include "UnitOwner.h"
#include "UnitTracker.h"

/*
	Implementation of the StrategyManager
*/

using namespace BWAPI;

UnitOwner* UnitTracker::getUnitOwner(const Unit unit) const
{
	if(unitsToOwners.count(unit) == 0)
		return nullptr;
	else
		return unitsToOwners.at(unit);
}

void UnitTracker::setOwner(Unit unit, UnitOwner* owner)
{
	unitsToOwners[unit] = owner;
}

const Unitset& UnitTracker::getSelfBuildings()
{
	return selfBuildings;
}

const Unitset& UnitTracker::getSelfArmyUnits()
{
	return selfArmyUnits;
}

const Unitset& UnitTracker::getSelfWorkerUnits()
{
	return selfWorkerUnits;
}

void UnitTracker::validateSelfUnits()
{
	selfBuildings.clear();
	selfArmyUnits.clear();
	selfWorkerUnits.clear();

	Unitset units = Broodwar->self()->getUnits();

	for(auto it = units.begin(); it != units.end(); ++it)
	{
		if(UnitUtils::isUnitValid(*it))
		{
			Unit u = *it;
			UnitType type = u->getType();

			if(type.isBuilding())
			{
				selfBuildings.push_back(u);
			}
			else if(type.isWorker())
			{
				selfWorkerUnits.push_back(u);
			}
			else
			{
				selfArmyUnits.push_back(u);
			}
		}
	}
}

void UnitTracker::assignWorkerToResource(Unit worker, Unit resource)
{
	if(resourcesToAssignedWorkers.count(resource) == 0)
		resourcesToAssignedWorkers[resource] = Unitset();

	Unitset& assigned = resourcesToAssignedWorkers[resource];
	assigned.push_back(worker);
}

const int UnitTracker::getNumAssignedWorkers(Unit resource)
{
	if(resourcesToAssignedWorkers.count(resource) == 0)
		return 0;
	else
		return resourcesToAssignedWorkers[resource].size();
}

void UnitTracker::removeWorkerFromResource(Unit worker, Unit resource)
{
#ifdef MAASCRAFT_DEBUG
	if(resourcesToAssignedWorkers.count(resource) == 0)
	{
		LOG_WARNING("Attempted to remove Worker from Resource which didn't have any workers allocated yet!")
		return;
	}
#endif

	Unitset& assigned = resourcesToAssignedWorkers[resource];
	assigned.erase(worker);
}