/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Subclasses of this class can own Units.
*/

#include "CommonIncludes.h"

class UnitOwner
{
private:
	BWAPI::Unitset units;

public:
	UnitOwner() : units() {}

	virtual void receiveOwnership(const BWAPI::Unit unit);
	virtual void removeOwnership(const BWAPI::Unit unit);

	const BWAPI::Unitset& getOwnedUnits() const;
	void transferOwnershipTo(const BWAPI::Unit unit, UnitOwner* newOwner);
};