/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Implementation of UnitOwner.h
*/

#include "CommonIncludes.h"

#include "UnitTracker.h"
#include "UnitOwner.h"

using namespace BWAPI;

const Unitset& UnitOwner::getOwnedUnits() const
{
	return units;
}

void UnitOwner::receiveOwnership(const Unit unit)
{
	UnitTracker::Instance()->setOwner(unit, this);
	units.push_back(unit);
}

void UnitOwner::removeOwnership(const Unit unit)
{
	units.erase(unit);
}

void UnitOwner::transferOwnershipTo(const Unit unit, UnitOwner* newOwner)
{
	removeOwnership(unit);
	newOwner->receiveOwnership(unit);
}