/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "../CommonIncludes.h"

#include "../BaseManager.h"
#include "../DebugDrawing.h"
#include "../Squad.h"
#include "../UnitOwner.h"
#include "../UnitTracker.h"
#include "../UnitUtils.h"
#include "CombatBehaviourRetreat.h"
#include "TargetSelection.h"

using namespace BWAPI;

void Behaviours::combatBehaviourRetreat(Unit unit, const Position& destination)
{
	const UnitType type = unit->getType();
	
	if(UnitUtils::canAttack(unit) && unit->getShields() > 60)		// find a target to attack
	{
		const WeaponType airWeapon = type.airWeapon();
		const WeaponType groundWeapon = type.groundWeapon();

		Unitset potentialTargets;

		if(airWeapon != WeaponTypes::None)
			potentialTargets.push_back(UnitUtils::getUnitsInWeaponRange(unit, airWeapon, Filter::IsEnemy));

		if(groundWeapon != WeaponTypes::None)
			potentialTargets.push_back(UnitUtils::getUnitsInWeaponRange(unit, groundWeapon, Filter::IsEnemy));

		if(potentialTargets.empty())
		{
			unit->move(destination);
		}
		else
		{
			BWAPI::Unit target = TargetSelection::selectTarget(unit, potentialTargets);

			if(target)
			{
				UnitCommand currentCommand = unit->getLastCommand();
				if(currentCommand.getType() != UnitCommandTypes::Attack_Unit || currentCommand.getTarget() != target)
				{
					DebugDrawing::drawLineMap(unit->getPosition(), target->getPosition(), Colors::Red);
					unit->attack(target);
				}
				else
				{
					DebugDrawing::drawLineMap(unit->getPosition(), target->getPosition(), Colors::Orange);
				}
			}
		}
	}
	else if(UnitUtils::canMove(unit))	// kite away
	{
		if(unit->isStuck())
		{
			const std::vector<Base>& bases = BaseManager::Instance()->getSelfBases();

			if(bases.size() > 0)
				unit->move(bases.front().getDepotCenter());
			else
				unit->move(destination - Position(1, 1));
		}
		else
		{
			unit->move(destination);
		}
	}
}