/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "../CommonIncludes.h"

#include "../ArmyManager.h"
#include "../DebugDrawing.h"
#include "../Distances.h"
#include "../OpponentTracker.h"
#include "../Squad.h"
#include "../UnitOwner.h"
#include "../UnitTracker.h"
#include "../UnitUtils.h"
#include "../WorkerManager.h"
#include "AvoidGroundThreats.h"
#include "CombatBehaviourFight.h"
#include "TargetSelection.h"

#include <typeinfo>

using namespace BWAPI;

const bool Behaviours::combatBehaviourFight(Unit unit)
{
	const UnitType type = unit->getType();
		
	if(type == UnitTypes::Protoss_Zealot || type == UnitTypes::Protoss_Probe)	// melee
	{
		if(unit->isStuck() && type != UnitTypes::Protoss_Probe)
		{
			Unitset potentialTargets = UnitUtils::getUnitsInRadius(unit, 30, Filter::IsEnemy && Filter::IsDetected && !Filter::IsFlying);
			if(potentialTargets.empty())
			{
				unit->move(unit->getPosition());
			}
			else
			{
				unit->attack(UnitUtils::getClosestUnit(unit, potentialTargets));
			}
		}

		// always either attack or chase depending on whether or not the unit can already attack
		const WeaponType groundWeapon = type.groundWeapon();

		Unitset potentialTargets = UnitUtils::getUnitsInRadius(unit, 650, Filter::IsEnemy && Filter::IsDetected);
		if(potentialTargets.empty())
		{
			UnitOwner* owner = UnitTracker::Instance()->getUnitOwner(unit);
			Squad* squad = dynamic_cast<Squad*>(owner);

			if(squad)
			{
				potentialTargets = squad->getPotentialTargets(unit);
			}
			else
			{
				WorkerManager* workerManager = dynamic_cast<WorkerManager*>(owner);

				if(workerManager)
				{
					potentialTargets = workerManager->getPotentialTargets(unit);
				}
				else
				{
					ArmyManager* armyManager = dynamic_cast<ArmyManager*>(owner);

					if(armyManager)
					{
						potentialTargets = armyManager->getPotentialTargets(unit);
					}
					else
					{
						LOG_WARNING("CombatBehaviourFight returning false because unit not owned by Squad or WorkerManager or ArmyManager!")
						return false;
					}
				}
			}
		}

		Unit target = TargetSelection::selectTarget(unit, potentialTargets);

		if(target)
		{
			if(target->getType() == UnitTypes::Terran_Vulture_Spider_Mine)
			{
				Behaviours::avoidGroundThreats(unit);
			}

			UnitCommand currentCommand = unit->getLastCommand();

			if(UnitUtils::canMove(unit) && !(target->isVisible()))
			{
				unit->move(OpponentTracker::Instance()->getLastPosition(target));
			}
			else if(UnitUtils::canAttack(unit))
			{
				if(unit->isIdle()												|| 
					currentCommand.getType() != UnitCommandTypes::Attack_Unit	|| 
					currentCommand.getTarget() != target							)
				{
					unit->attack(target);
				}
			}
			else if(currentCommand.getType() == UnitCommandTypes::Attack_Unit && currentCommand.getTarget())
			{
				if(UnitUtils::damageToTarget(currentCommand.getTarget(), unit) <= 0.0f	&&		// currently targeting something harmless
					UnitUtils::damageToTarget(target, unit) > 0.0f							)	// new target would not be harmless
				{
					unit->attack(target);
				}
			}

			return true;
		}
		return false;
	}
	else
	{
		const bool flyer = type.isFlyer();

		if(UnitUtils::canAttack(unit))		// find a target to attack
		{
			const WeaponType airWeapon = type.airWeapon();
			const WeaponType groundWeapon = type.groundWeapon();

			Unitset potentialTargets = UnitUtils::getUnitsInRadius(unit, 750, Filter::IsEnemy && Filter::IsDetected);

			if(potentialTargets.empty())
			{
				UnitOwner* owner = UnitTracker::Instance()->getUnitOwner(unit);
				Squad* squad = dynamic_cast<Squad*>(owner);

				if(squad)
				{
					potentialTargets = squad->getPotentialTargets(unit);
				}
				else
				{
					WorkerManager* workerManager = dynamic_cast<WorkerManager*>(owner);

					if(workerManager)
					{
						potentialTargets = workerManager->getPotentialTargets(unit);
					}
					else
					{
						ArmyManager* armyManager = dynamic_cast<ArmyManager*>(owner);

						if(armyManager)
						{
							potentialTargets = armyManager->getPotentialTargets(unit);
						}
						else
						{
							LOG_WARNING("CombatBehaviourFight returning false because unit not owned by Squad or WorkerManager or ArmyManager!")
							return false;
						}
					}
				}
			}

			Unit target = TargetSelection::selectTarget(unit, potentialTargets);

			if(target)
			{
				UnitCommand currentCommand = unit->getLastCommand();
				if(unit->isIdle()												|| 
					currentCommand.getType() != UnitCommandTypes::Attack_Unit	|| 
					currentCommand.getTarget() != target							)
				{
					unit->attack(target);
				}

				return true;
			}

			return false;
		}
		else if(UnitUtils::canMove(unit))	// kite away
		{
			if(!flyer)
			{
				if(OpponentTracker::Instance()->getGroundThreat(unit->getPosition()) > 0.0f)
				{
					Behaviours::avoidGroundThreats(unit);
				}
				else
				{
					Unitset potentialTargets = UnitUtils::getUnitsInRadius(unit, 750, Filter::IsEnemy && Filter::IsDetected);

					if(!potentialTargets.empty())
					{
						unit->move(potentialTargets.front()->getPosition());
					}
				}

				return true;
			}
			else
			{
				if(OpponentTracker::Instance()->getGroundThreat(unit->getPosition()) > 0.0f)
				{
					LOG_WARNING("TODO: Implement avoidAirThreats behaviour!")
				}
				else
				{
					Unitset potentialTargets = UnitUtils::getUnitsInRadius(unit, 750, Filter::IsEnemy && Filter::IsDetected);

					if(!potentialTargets.empty())
					{
						unit->move(potentialTargets.front()->getPosition());
					}
				}
				
				return true;
			}
		}
		else		// must stay idle, cant move or attack
		{
			return true;
		}
	}
}