/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "../CommonIncludes.h"

#include "../DebugDrawing.h"
#include "../MapAnalyser.h"
#include "../MathConstants.h"
#include "../OpponentTracker.h"
#include "../PositionUtils.h"
#include "AvoidGroundThreats.h"

using namespace BWAPI;

void Behaviours::avoidGroundThreats(Unit unit)
{
	MapAnalyser* mapAnalyser = MapAnalyser::Instance();
	OpponentTracker* opponentTracker = OpponentTracker::Instance();
	TilePosition currentPos = PositionUtils::toTilePosition(unit->getPosition());

	WalkPosition bestPosition = WalkPositions::Invalid;
	float bestPotential = MathConstants::MIN_FLOAT;

	// Evaluate some TilePositions around currentPos
	TilePosition leftTop = (currentPos - TilePosition(1, 1)).makeValid();
	TilePosition rightBot = (currentPos + TilePosition(1, 1)).makeValid();

	for(int tileY = leftTop.y; tileY <= rightBot.y; ++tileY)
	{
		const int startY = tileY * 4;
		for(int tileX = leftTop.x; tileX <= rightBot.x; ++tileX)
		{
			// within this tile position, loop through all the Walkpositions to add clearance to potential
			const float groundThreat = opponentTracker->getGroundThreat(tileX, tileY);

			const int startX = tileX * 4;

			WalkPosition bestTempPosition = WalkPositions::Invalid;
			float highestClearance = MathConstants::MIN_FLOAT;

			for(int y = 0; y < 4; ++y)
			{
				int walkY = startY + y;

				for(int x = 0; x < 4; ++x)
				{
					int walkX = startX + x;
					if(!mapAnalyser->isWalkable(walkX, walkY))
						continue;

					float clearance = 0.1f * mapAnalyser->getClearance(walkX, walkY);

					if(clearance > highestClearance)
					{
						highestClearance = clearance;
						bestTempPosition = WalkPosition(walkX, walkY);
					}
				}
			}

			float potential = highestClearance - groundThreat;

			if(potential > bestPotential)
			{
				bestPotential = potential;
				bestPosition = bestTempPosition;
			}
		}
	}

	if(bestPosition != WalkPositions::Invalid)
	{
		unit->move(PositionUtils::toPosition(bestPosition));
	}
}