/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	Starcraft Brood Wars bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
Declares a wrapper class around BWAPI's Unit class, to save any additional information and
provide functionality with respect to controlling individual units

Most modules should probably use this class instead of BWAPI's unit class
*/

#pragma once

#include "BWAPI.h"

namespace Actions
{

	// Only interested in combat actions
	enum ActionTypes
	{
		NONE,
		ATTACK,
		MOVE
	};

}

class Unit
{

public:

	Unit(const BWAPI::Unit & bwapi_unit);
	~Unit();

	inline const BWAPI::Unit &	getBwapiUnit()		const	{ return bwapi_unit; }
	inline const BWAPI::UnitType &	getUnitType()	const	{ return bwapi_unit -> getType(); }

	void update();											// perform any updating required on frame

private:

	BWAPI::Unit bwapi_unit;					// The BWAPI Unit wrapped inside this object
	Actions::ActionTypes last_action;		// Last executed combat action
	unsigned last_action_frame;
	unsigned last_attack_frame;

};