/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A Node in our UCT algorithm's tree
*/

#include "CommonIncludes.h"

#ifdef ARMY_MANAGER_UCT

#include <vector>

#include "Action.h"
#include "GameState.h"

class UCTNode
{
public:
	UCTNode(GameState& gameState, Action parentMove, UCTNode* parentNode);
	~UCTNode();

	UCTNode* bestChild_maxAvgReward() const;
	UCTNode* bestChild_maxVisitCount() const;
	UCTNode* bestChild_maxVisitCount(std::string caller) const;
	UCTNode* bestChild_UCB1() const;

	void addReward(const double reward);
	UCTNode* generateChild(GameState& gameState, Action actionToApply);
	const std::vector<UCTNode*>& getChildren() const;
	const int getNumVisits() const;
	Action getParentAction() const;
	UCTNode* getParentNode() const;
	BWAPI::Player getPlayerToMove() const;
	UCTNode* getRandomChild() const;
	const double getRewardSum() const;
	const bool hasUntriedActions() const;
	void incrementVisitCount();
	Action nextUntriedAction();

private:
	std::vector<Action> untriedActions;
	std::vector<UCTNode*> children;
	Action parentAction;
	BWAPI::Player playerToMove;
	double rewardSum;
	int numVisits;
	UCTNode* parentNode;
};

#endif // ARMY_MANAGER_UCT