/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Search engine for Tactical Planning using the UCT algorithm
*/

#include "CommonIncludes.h"

#ifdef ARMY_MANAGER_UCT

#include "Action.h"
#include "GameState.h"
#include "Squad.h"
#include "UCTNode.h"

class UCT
{
public:
	UCT();
	~UCT();

	const int getStartFrame() const;

	void init(const std::vector<BWAPI::Unitset>& airSquads, const std::vector<BWAPI::Unitset>& groundSquads);
	void fillSquads(std::vector<Squad*>& airSquads, std::vector<Squad*>& groundSquads);

	void backPropagate(UCTNode* node, const double reward);
	const double defaultPolicy(GameState& gameState);
	UCTNode* expand(UCTNode* node);
	UCTNode* treePolicy(UCTNode* node);
	
	// EVENTS
	void onFrame(const int allowedMilliSeconds);

#ifdef MAASCRAFT_DEBUG
	void logRandomTraversal();
	void setVerbose();
#endif

private:
	GameState trueGameState;
	GameState gameStateCopy;
	std::unordered_map<Action, Pair<double, int>> mastMap;
	UCTNode* rootNode;
	int startFrame;

#ifdef MAASCRAFT_DEBUG
	bool verbose;
#endif
};

#endif // ARMY_MANAGER_UCT