/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

#include <cmath>
#include "BWAPI.h"
#include "Point2D.h"

/*
	Utility functions for transformations using Point2D or BWAPI::Point objects
*/

namespace Transformations
{
	// Rotate a given point by a given amount of radians counter-clockwise around a given center
	const Point2D rotatePoint(const double radians, const Point2D & point, const Point2D & center);

	// Rotate a given BWAPI::Position by a given amount of radians counter-clockwise around a given center
	const BWAPI::Position rotatePosition(const double radians, const BWAPI::Position & point, const BWAPI::Position & center);
}