/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "Transformations.h"

#pragma warning( push )
#pragma warning( disable : 4244 )

const Point2D Transformations::rotatePoint(const double radians, const Point2D& point, const Point2D& center)
{
	double dx = point.x - center.x;
	double dy = point.y - center.y;

	double x = ((dx * cos(radians)) - (dy * sin(radians)));
	double y = ((dy * cos(radians)) - (dx * sin(radians)));

	return Point2D(x + center.x, y + center.y);
}

const BWAPI::Position Transformations::rotatePosition(const double radians, const BWAPI::Position& point, const BWAPI::Position& center)
{
	double dx = point.x - center.x;
	double dy = point.y - center.y;

	double x = ((dx * cos(radians)) - (dy * sin(radians)));
	double y = ((dy * cos(radians)) - (dx * sin(radians)));

	return BWAPI::Position(x + center.x, y + center.y);
}

#pragma warning( pop )