/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task for a Worker to defend a base
*/

#pragma once

#include "../CommonIncludes.h"

#include "../Base.h"
#include "../Distances.h"
#include "../OpponentTracker.h"
#include "../PositionUtils.h"
#include "../Task.h"
#include "../UnitBehaviours/CombatBehaviourFight.h"
#include "../UnitUtils.h"
#include "../WorkerManager.h"

class WorkerDefendBase : public Task
{
private:
	Base base;
	BWAPI::Unit worker;

public:
	WorkerDefendBase(const int priority, const Base& base, const BWAPI::Unit worker) : 
	  Task(priority), base(base), worker(worker) {}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return true;
	}

	void execute()
	{
		if(UnitUtils::isInCombat(worker))
		{
			if(Behaviours::combatBehaviourFight(worker))
				return;
		}

		BWAPI::Unitset opponents = OpponentTracker::Instance()->getOpponentsInRegion(base.getLocation()->getRegion());

		for(auto it = opponents.begin(); it != opponents.end(); ++it)
		{
			BWAPI::Unit unit = *it;
			BWAPI::UnitType type = unit->getType();

			if(type.isFlyer())
				continue;

			worker->move(unit->getPosition());
			return;
		}
	}

	inline const bool isFinished() const
	{
		return (WorkerManager::Instance()->numDefendersNeeded() == 0);
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return true;
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return "Workers Defend Base!";
	}
#endif
};