/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to train units until a certain number of the type has been trained
*/

#pragma once

#include "../CommonIncludes.h"

#include "../BaseLocation.h"
#include "../Predicates.h"
#include "../Priorities.h"
#include "../ProductionManager.h"
#include "../Task.h"
#include "ProductionTask.hpp"

class TrainUnits : public ProductionTask
{
private:
	BaseLocation* preferredBase;
	int bound;

public:
	TrainUnits(const int priority, BWAPI::UnitType unitToTrain, const int numUnits, BaseLocation* preferredBase = nullptr) : 
	  ProductionTask(priority, unitToTrain), preferredBase(preferredBase), bound(numUnits + BWAPI::Broodwar->self()->completedUnitCount(unitToTrain)) {}

	void onStart()
	{
		ProductionTask::onStart();
		ProductionManager::Instance()->onStartProduction(getProductionType());
	}

	inline const bool repeatTask() const
	{
		return ((BWAPI::Broodwar->self()->completedUnitCount(getProductionType())			+ 
				ProductionManager::Instance()->getNumUnitsProducing(getProductionType())		) < bound);
	}

	inline const bool isInstantaneous() const
	{
		return true;
	}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return ProductionManager::Instance()->canTrainUnit(getProductionType());
	}

	void execute()
	{
		BWAPI::Unit trainer = ProductionManager::Instance()->getIdleTrainer(getProductionType(), preferredBase);
		trainer->train(getProductionType());
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return ((BWAPI::Broodwar->self()->completedUnitCount(getProductionType())			+ 
				ProductionManager::Instance()->getNumUnitsProducing(getProductionType())		) < bound);
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return (StringBuilder() << "Construct unit: " << getProductionType()).getString();
	}
#endif
};