/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to train units
*/

#pragma once

#include "../CommonIncludes.h"

#include "../BaseLocation.h"
#include "../Predicates.h"
#include "../Priorities.h"
#include "../ProductionManager.h"
#include "../Task.h"
#include "ProductionTask.hpp"

template <typename SchedulePred = Predicates::Tautology, typename IsValidPred = Predicates::Tautology>
class TrainUnit : public ProductionTask
{
private:
	BaseLocation* preferredBase;

public:
	TrainUnit(const int priority, BWAPI::UnitType unitToTrain, BaseLocation* preferredBase = nullptr) : 
	  ProductionTask(priority, unitToTrain), preferredBase(preferredBase) {}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return ProductionManager::Instance()->canTrainUnit(getProductionType());
	}

	void execute()
	{
		BWAPI::Unit trainer = ProductionManager::Instance()->getIdleTrainer(getProductionType(), preferredBase);
		trainer->train(unitToTrain);
	}

	inline const bool isInstantaneous() const
	{
		return true;
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return IsValidPred()();
	}

	inline const bool scheduleConditions() const
	{
		return SchedulePred()();
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return (StringBuilder() << "Train unit: " << getProductionType()).getString();
	}
#endif
};