/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to train as many Probes as our bases want
*/

#pragma once

#include "../CommonIncludes.h"

#include "../BaseLocation.h"
#include "../BaseManager.h"
#include "../Predicates.h"
#include "../Priorities.h"
#include "../ProductionManager.h"
#include "../Task.h"
#include "ProductionTask.hpp"

class TrainProbes : public ProductionTask
{
public:
	TrainProbes(const int priority) : 
	  ProductionTask(priority, BWAPI::UnitTypes::Protoss_Probe) {}

	void onStart()
	{
		ProductionTask::onStart();
		ProductionManager::Instance()->onStartProduction(BWAPI::UnitTypes::Protoss_Probe);
	}

	inline const bool repeatTask() const
	{
		return true;
	}

	inline const bool isInstantaneous() const
	{
		return true;
	}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return ProductionManager::Instance()->canTrainUnit(BWAPI::UnitTypes::Protoss_Probe);
	}

	void execute()
	{
		BWAPI::Unit trainer = ProductionManager::Instance()->getIdleTrainer(BWAPI::UnitTypes::Protoss_Probe);
		trainer->train(BWAPI::UnitTypes::Protoss_Probe);
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return ((WorkerManager::Instance()->getOwnedUnits().size()									+ 
				ProductionManager::Instance()->getNumUnitsProducing(BWAPI::UnitTypes::Protoss_Probe)	) < BaseManager::Instance()->getMaxNumWorkers());
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return (StringBuilder() << "Construct unit: " << BWAPI::UnitTypes::Protoss_Probe).getString();
	}
#endif
};