/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Useful predicates for Task Scheduling
*/

#pragma once

#include "../CommonIncludes.h"

#include "../BaseManager.h"

namespace TaskSchedulePreds
{
	template <BWAPI::UnitTypes::Enum::Enum unitType, size_t minimumCount>
	struct AtOrAboveCompletedUnitCount
	{
		inline const bool operator() ()
		{
			return (BWAPI::Broodwar->self()->completedUnitCount(unitType) >= minimumCount);
		}
	};

	template <int supply>
	struct AtOrAboveSupply
	{
		inline const bool operator() ()
		{
			return BWAPI::Broodwar->self()->supplyUsed() >= 2 * supply;
		}
	};

	template <BWAPI::UnitTypes::Enum::Enum unitType, size_t minimumCount>
	struct AtOrAboveTotalUnitCount
	{
		inline const bool operator() ()
		{
			return (BWAPI::Broodwar->self()->allUnitCount(unitType) >= minimumCount);
		}
	};

	template <BWAPI::UpgradeTypes::Enum::Enum upgradeType>
	struct HasOrIsUpgrading
	{
		inline const bool operator() ()
		{
			return (BWAPI::Broodwar->self()->getUpgradeLevel(upgradeType) > 0 ||
					BWAPI::Broodwar->self()->isUpgrading(upgradeType)			);
		}
	};

	struct NoEnemyBaseFound
	{
		inline const bool operator() ()
		{
			return (BaseManager::Instance()->getOpponentBases().size() == 0);
		}
	};
}