/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to spam Units of a certain Unit Type while a certain Strategy is being played.
*/

#pragma once

#include "../CommonIncludes.h"

#include "../BaseLocation.h"
#include "../Predicates.h"
#include "../Priorities.h"
#include "../ProductionManager.h"
#include "../StrategyManager.h"
#include "../Task.h"
#include "ProductionTask.hpp"

class SpamUnitsStrategy : public ProductionTask
{
private:
	BaseLocation* preferredBase;
	int strategyID;

public:
	SpamUnitsStrategy(const int priority, BWAPI::UnitType unitToTrain, const int strategyID, BaseLocation* preferredBase = nullptr) : 
	  ProductionTask(priority, unitToTrain), preferredBase(preferredBase), strategyID(strategyID) {}

	void onStart()
	{
		ProductionTask::onStart();
		ProductionManager::Instance()->onStartProduction(getProductionType());
	}

	inline const bool repeatTask() const
	{
		return true;
	}

	inline const bool isInstantaneous() const
	{
		return true;
	}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return ProductionManager::Instance()->canTrainUnit(getProductionType());
	}

	void execute()
	{
		BWAPI::Unit trainer = ProductionManager::Instance()->getIdleTrainer(getProductionType(), preferredBase);
		trainer->train(getProductionType());
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return (strategyID == Strategies::ANY_STRATEGY || strategyID == StrategyManager::Instance()->getCurrentStrategy());
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return (StringBuilder() << "Construct unit: " << getProductionType()).getString();
	}
#endif
};