/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to spam Units of a certain Unit Type while a certain Strategy is being played.
*/

#pragma once

#include "../CommonIncludes.h"

#include "../BaseLocation.h"
#include "../Predicates.h"
#include "../Priorities.h"
#include "../ProductionManager.h"
#include "../StrategyManager.h"
#include "../Task.h"
#include "ProductionTask.hpp"

class SpamUnitSequence : public ProductionTask
{
private:
	std::vector<BWAPI::UnitType> unitsToTrain;
	int strategyID;
	size_t index;

public:
	SpamUnitSequence(const int priority, std::vector<BWAPI::UnitType> armyComposition, const int strategyID, const size_t startIndex = 0) : 
	  ProductionTask(priority, armyComposition.at(startIndex)), unitsToTrain(armyComposition), strategyID(strategyID), index(startIndex) {}

	void onStart()
	{
		ProductionTask::onStart();
		ProductionManager::Instance()->onStartProduction(getProductionType());
	}

	inline const bool repeatTask() const
	{
		return true;
	}

	inline const bool isInstantaneous() const
	{
		return true;
	}

	Task* reset()
	{
		++index;

		if(index >= unitsToTrain.size())
			index = 0;

		ProductionTask::setProductionType(unitsToTrain.at(index));

		return this;
	}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return ProductionManager::Instance()->canTrainUnit(getProductionType());
	}

	void execute()
	{
		BWAPI::Unit trainer = ProductionManager::Instance()->getIdleTrainer(getProductionType());
		trainer->train(getProductionType());
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return (strategyID == Strategies::ANY_STRATEGY || strategyID == StrategyManager::Instance()->getCurrentStrategy());
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return (StringBuilder() << "Construct unit: " << getProductionType()).getString();
	}
#endif
};