/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to have a Squad retreat to a location
*/

#pragma once

#include "../CommonIncludes.h"

#include "../Squad.h"
#include "../Task.h"
#include "../UnitBehaviours/CombatBehaviourRetreat.h"
#include "../UnitUtils.h"

#ifdef ARMY_MANAGER_UCT

class RetreatSquad : public Task
{
private:
	BWAPI::Position position;
	Squad* squad;

public:
	RetreatSquad(const int priority, Squad* squad, const BWAPI::Position& position) : 
	  Task(priority), position(position), squad(squad) {}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return true;
	}

	void execute()
	{
		const BWAPI::Unitset& units = squad->getOwnedUnits();

		for(auto it = units.begin(); it != units.end(); ++it)
		{
			const BWAPI::Unit unit = *it;

			if(UnitUtils::isInCombat(unit))
			{
				Behaviours::combatBehaviourRetreat(unit, position);
			}
			else
			{
				if(unit->isStuck())
				{
					const std::vector<Base>& bases = BaseManager::Instance()->getSelfBases();

					if(bases.size() > 0)
						unit->move(bases.front().getDepotCenter());
					else
						unit->move(position - BWAPI::Position(1, 1));
				}
				else
				{
					unit->move(position);
				}
			}
		}
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return true;
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return "Retreat Squad";
	}
#endif
};

#endif // ARMY_MANAGER_UCT